# Simulations for the JSS publication
# sgmcmc: An R Package for Stochastic Gradient Markov Chain Monte Carlo
# by Jack Baker, Christopher Nemeth, Paul Fearnhead, Emily B. Fox

### Running the simulations

To run the simulations simply run the script `code.R`. The plot output corresponding
to each simulation will appear in the directory `plots`.


### Dependencies

The simulations depend on the following `R` packages: `sgmcmc` (the package itself),
`rstan`, `MASS`, `ggplot2` (all available on `CRAN`). These dependencies should 
be automatically installed when `code.R` is run. The script will also check
`TensorFlow` for `R` (also available on `CRAN`) has been installed properly,
which is a dependency for `sgmcmc`. If it is not, it will attempt to install
this itself. The installation of `TensorFlow` for `R` requires `python-pip` and
`python-virtualenv` to be installed so if these are not available the script
will stop and prompt you to install these.


### System requirements

Some of the simulations load large datasets into memory, so it's recommended 
you have at least 8GB of RAM.


### Run time

Simulations took approximately 3 hours on a quad core i5 laptop with 8GB RAM.


### Troubleshooting

`Error: Python module tensorflow was not found.` -- Try rerunning `code.R` or
restarting your `R` session. This Error can sometimes occur when `TensorFlow` is 
installed during the `code.R` script and then is immediately called. Restarting 
the `R` session and rerunning the script should solve the error.

### Original Setup Details

Original results were run on a laptop with Ubuntu 16.04 LTS; `R` version 3.2.3; 
`Python` version 2.7.12; `TensorFlow` version 1.7.0; `TensorFlow` for `R` version
1.5; `sgmcmc` version 0.2.2; `rstan` version 2.16.2. 

### Remarks

While we can guarantee reproducibility on a single platform, and have ensured 
reproducibility across two platforms (see Original Setup Section). The `TensorFlow`
seed setting appears to be very dependent on version and platform, this can make 
reproducibility across different platforms difficult. We have done our best to
make everything as reproducible as possible and have given as much detail as 
possible of our set up in the Original Setup Section to make it easier.
