%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                   Main body of the CPU program 
%
%% TIPS TO RUN THE CPU CODE IN PARALLEL
% Open the parallel computing toolbox by adding the following command
% matlabpool open;
% in this file or directly in the Matlab command window before to run the GUI
% If using Matlab 2012b, please remember to set the path with the DeCo
% package using the command "Set Path" and then add the path "...\DeCoPackage" 
% Matlab 2013a and following versions do it automatically
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[cT, iM, iL, iKL] = size(mX);
iSelectSeries = 1:1:iL;             %%------ Select the iL series -------%%
vY = vY(end - cT + 1:end, iSelectSeries);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                         Parameter setting                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Setting.cN = cN;                                    %%% Number of particles
Setting.iDimOmega = iKL;                            %%% State space dimension
Setting.iM = iM;                                    %%% M parameter
Setting.iL = iL;                                    %%% L parameter
Setting.cT = cT;                                    %%% Time dimension
Setting.dLambda = dLambda;                          %%% Lambda matrix 
Setting.iEstimate = dVar;                           %%% Estimate or not the Lambda and Sigma
Setting.dKappa = dKappa;                            %%% Resampling parameter 
if iLearning == 0                                   %%% Learning or not
    Setting.iTau = -1;
else
    Setting.iTau = iTau;
end
%%-------------------- Setting the Sigma and Lambda matrix --------------%%
mSigmaTemp = [];
vSigmaTemp = [];
for i = 1:Setting.iL
   vSigmaTemp = [vSigmaTemp; log(mDataRand(i, 1))];
   mSigmaTemp =  [mSigmaTemp; log(mDataRand(i, 2)) * ones(1, Setting.iDimOmega)]; 
end
Setting.Sigma = mSigmaTemp;
Setting.vSigma = vSigmaTemp;
%%% ------------ Create the matrix that will save the results --------- %%% 
mWeights = zeros(Setting.cT, Setting.iDimOmega, Setting.iL, Setting.iM);
mYPred = zeros(Setting.cT, 3,  Setting.iL, Setting.iM);
TrueweightsCumRange = zeros(Setting.cT, Setting.iDimOmega, 4, Setting.iL);
mSigma = zeros(Setting.cT, Setting.iL, Setting.iM);
mLambda = zeros(Setting.cT, Setting.iDimOmega, Setting.iL, Setting.iM);
%%% ------------------ Start run filtering and timing ----------------- %%%
tic;
parfor g = 1:Setting.iM
    mError = zeros(Setting.cT, Setting.iDimOmega, Setting.iL);
    mXInit = zeros(Setting.cT, Setting.iDimOmega, Setting.iL);
    disp(char('We are at the iteration: ', num2str(g)));
    %%% ---------------- Construct the mX and mError ------------------ %%%
    for i = 1:Setting.iL
        mXInit(:, :, i) = reshape(mX(:, g, i, :), Setting.cT, Setting.iDimOmega);
        mError(:, :, i) = (Kronbsxfun(ones(1, Setting.iDimOmega), vY(:, i)) - mXInit(:, :, i)).^2;
    end
    [S0] = initPSCPU(Setting, vY, mXInit);
    [SSta0] = initStaCPU(Setting);
    [S, SSta] = PFCPU(Setting, S0, SSta0, vY, mXInit, mError);
    mWeightsTemp = zeros(Setting.cT, Setting.iDimOmega, Setting.iL);
    for i = 1:Setting.cT
        for z = 1:Setting.iL
             mWeightsTemp(i, :, z) = logmul(SSta.mXFilt(i, :, z));  
        end     
    end    
    mWeights(:, :, :, g) = mWeightsTemp; 
    mYPred(:, :, :, g) = SSta.mYPred;
    mSigma(:, :, g) = SSta.mSigmaFilt;
    mLambda(:, :, :, g) = SSta.mLambdaFilt;
end
toc;
%%%%%%%%%%%%%%%%%%%%%%%%% Statistics %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for kk = 1:Setting.iDimOmega
    for tt = 1:Setting.cT
        for i = 1:Setting.iL
            TrueweightsCumRange(tt, kk, 1, i) = quantile(mWeights(tt, kk, i, :), 0.025);
            TrueweightsCumRange(tt, kk, 2, i) = quantile(mWeights(tt, kk, i, :), 0.975);
            TrueweightsCumRange(tt, kk, 3, i) = median(mWeights(tt, kk, i, :), 4);
            TrueweightsCumRange(tt, kk, 4, i) = mean(mWeights(tt, kk, i, :), 4);     
        end
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                           Figures 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if (iPlot == 1)
  FiguresCPU(TrueweightsCumRange, mSigma, mLambda, mYPred, Setting, iSave);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       Saving the data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cd('..');
if (iSave == 1)
    cd('OutputCPU');
    save('TrueweightsCumRange.mat','TrueweightsCumRange');
    save('mYPred.mat','mYPred');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% EOF %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%