%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%           Core function for the Particle Filter
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S] = PFCoreCPU(S, Setting, vY, mXTot, vErrorTot)
    vLogLik = zeros(Setting.cN, 1);
    for i=1:Setting.cN;  %% Leaning parameter just added 
        % ----------------- simulate from the proposal ------------------ %
        if Setting.iTau > 0
            if S.t<=(Setting.iTau + 1);
               %%-NOP-%%
            else
                for j=1:Setting.iTau
                    for z = 1:Setting.iL
                        S.mOmega(i, :, z) = S.mOmega(i, :, z) - ...
                            (1 - Setting.dLambda) * Setting.dLambda^(j - 1) * ...
                            (vErrorTot(S.t - j, :, z) - vErrorTot((S.t - j - 1), :, z));
                    end 
                end
            end
        end
        %%%--------------- Update the mOmega states --------------------%%%
        mTemp = reshape(S.mOmega(i, :, :), 1, Setting.iDimOmega * Setting.iL)' + ...
            diag(exp(0.5 * reshape(S.mLambda(i, :, :), Setting.iDimOmega * Setting.iL, 1))) ...
            *randn(Setting.iDimOmega * Setting.iL, 1);
        S.mOmega(i, :, :) = reshape(mTemp,  Setting.iDimOmega,  Setting.iL);
        %%%--------------- Update the mLambda states -------------------%%%
        mTemp = reshape(S.mLambda(i, :, :), 1, Setting.iDimOmega * Setting.iL)' + ...
            Setting.iEstimate * randn(Setting.iDimOmega * Setting.iL, 1);
        S.mLambda(i, :, :) = reshape(mTemp,  Setting.iDimOmega,  Setting.iL);
        %%%--------------- Update the mSigma states --------------------%%%
        S.mSigma(i, :) = S.mSigma(i, :) + Setting.iEstimate * randn(1, Setting.iL);
        for z = 1:Setting.iL
            S.ytilde(i, z) =  logmul(S.mOmega(i, :, z)) * mXTot(S.t, :, z)' + exp(0.5 * S.mSigma(i, z)) * 1 * randn(1, 1);    
            vLogLik(i) = vLogLik(i) - 0.5 * log(exp(S.mSigma(i, z)) * pi) - 0.5 * ((vY(S.t, z) ...
                - logmul(S.mOmega(i, :, z)) * mXTot(S.t, :, z)')*...
            (vY(S.t, z) - logmul(S.mOmega(i, :, z)) * mXTot(S.t, :, z)'))/exp(S.mSigma(i, z));
        end
        S.w(i) = exp(log(S.w(i)) + vLogLik(i));
    end
end