%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%           Function that execute the PF at time t and does resampling
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S] = Resample_MoveCPU(S, Setting, vY, mXTot, vErrorTot)
    %%% ----------------------- PF ------------------------------------ %%%
    [S] = PFCoreCPU(S, Setting, vY, mXTot, vErrorTot);
    S.w = S.w./sum(S.w);        % normalize weights
    S.dEss = 1/sum(S.w.^2)/Setting.cN;
    %%% ------------------- Resampling -------------------------------- %%%
    S = extractPS(S, Setting);
    S.w = ones(Setting.cN, 1)/Setting.cN;
end 