%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%        Extract the particle system corresponding to indexes I in S
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Sext = extractPS(S, Setting)
     if (S.dEss < Setting.dKappa)
        I = EmpCPU(S.w, Setting.cN);
        Sext = struct('t', S.t, 'w', S.w(I), ...
        'ytilde', S.ytilde(I, :), 'loglik', S.loglik(I), 'mOmega', S.mOmega(I, :, :),...
        'mSigma', S.mSigma(I, :),'mLambda', S.mLambda(I, :, :));
     else
        Sext = struct('t', S.t, 'w', S.w, ...
        'ytilde', S.ytilde, 'loglik', S.loglik, 'mOmega', S.mOmega,...
        'mSigma', S.mSigma, 'mLambda', S.mLambda);
     end 
end