%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                   Resampling step
%           Simulate Empirical Density F. given weights and values     
%           m represents the number of bootstrapped values           
%
%       Note that we have a block of series but the resamplig has to
%       be done just in a subset. This is carried out buy creating
%       the relevant matrix mResamplingParticle and mResamplingParticleY
%       that using a progressive number does copy the same particle at the
%       same place. In a case of a series that to be resampled then 
%       the resampling thake place just for that series and the matrix
%       are created accordingly
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [mResamplingParticle, mResamplingParticleY]  = EmpGPU(w, cN, iDraws, iDim, iL, dEss, dKappa)
    vIndRes = 1:1:cN;
    mResamplingParticle = repmat(vIndRes', 1, iDraws * iDim);
    mResamplingParticleY = repmat(vIndRes', 1, iDraws * iL);
    z = 1; g = 1;
    for j = 1:iDraws
      if (dEss(j) < dKappa)
          dist = cumsum(w(j,:))';
          u = unifrnd(0, 1, cN, 1);
          for i=1:cN
                mResamplingParticle(i, z:z + iDim - 1) = sum(dist < (u(i) * ones(cN, 1))) + 1;
                mResamplingParticleY(i, g:g + iL - 1) =  mResamplingParticle(i, z);
          end
      else
      end
      z = z + iDim;
      g = g + iL;
    end    
    %%%%%%%%%%%%%%%%%%%%%%% Devide by the state and the Y %%%%%%%%%%%%%%%%%
    for j = 1:size(mResamplingParticle, 2)
        mResamplingParticle(:, j) =  mResamplingParticle(:, j) + (j - 1) * cN;
    end
    for j = 1:size(mResamplingParticleY, 2)
        mResamplingParticleY(:, j) =  mResamplingParticleY(:, j) + (j - 1) * cN;
    end
end