%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%           Execute the Particle Filter on the GPU 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Snew, SStaNew] = PFGPU(Setting, S, SSta, vY, mXTot, vErrorTot)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %                             step 1                              
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    S.t = 1;
    [Snew] = Resample_MoveGPU(S, Setting, vY, mXTot, vErrorTot);
    [SStaNew] = UpdateStaGPU(SSta, Snew, Setting);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %              step 2 Over the T dimension  but multivariate                         
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    for i = 2:gather(Setting.cT)
        Snew.t = i;
        [Snew] = Resample_MoveGPU(Snew, Setting, vY, mXTot, vErrorTot);
        [SStaNew] = UpdateStaGPU(SStaNew, Snew, Setting);
     end
end