%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       
%           Calculate the mean of the states 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [SStaNew] = UpdateStaGPU(SStaNew, S, Setting)
    %%%%%%%%%%%%%%%% Calculate the mean for the series %%%%%%%%%%%%%%%%%%%%
    for i = 1:gather(Setting.iL)
       mHelp = reshape(S.mOmega(:, :, i), Setting.iDraws, Setting.cN * Setting.iDimOmega)';   
       mHelp = reshape(mHelp(:), Setting.cN, Setting.iDimOmega * Setting.iDraws);
       SStaNew.mXFilt(:, S.t, i) = mean(mHelp)';
       %%%------------------ Calculate the mLambda ---------------------%%%
       SStaNew.mLambdaFilt(S.t, :, i) = mean(S.mLambda(:, :, i))';
    end
    clear mHelp;
    %%%%%%%%%%%%%%%% Save the y pred for each series and particles %%%%%%%%
    SStaNew.mYPred(S.t, :, :) = S.ytilde;
    %%%%%%%%%%% Save the mSigma pred for each series and particles %%%%%%%%
    SStaNew.mSigmaFilt(S.t, :) = mean(S.mSigma);
end