function varargout = DeCo_GUI(varargin)
% DeCo_GUI MATLAB code for DeCo_GUI.fig
%      DeCo_GUI, by itself, creates a new DeCo_GUI or raises the existing
%      singleton*.
%
%      H = DeCo_GUI returns the handle to a new DeCo_GUI or the handle to
%      the existing singleton*.
%
%      DeCo_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DeCo_GUI.M with the given input arguments.
%
%      DeCo_GUI('Property','Value',...) creates a new DeCo_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DeCo_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DeCo_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DeCo_GUI

% Last Modified by GUIDE v2.5 23-Apr-2014 18:17:49

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DeCo_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @DeCo_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before DeCo_GUI is made visible. --- %
function DeCo_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DeCo_GUI (see VARARGIN)
% Choose default command line output for DeCo_GUI
handles.output = hObject;
% Update handles structure
guidata(hObject, handles);
% UIWAIT makes DeCo_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                    Get the Video Card available  
%                    If there is no GPU available the GPU 
%                    botton is disabled
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[iNumDevice] = gpuDeviceCount;  %%% Get information about GPU  
if iNumDevice == 0
    % ------------------- Disable the unused elements ------------------- %
    set(handles.GPU, 'Visible','off');
    set(handles.Warning, 'Visible','off');
    set(handles.textBlock, 'Visible','off');
    set(handles.BlockNumber, 'Visible','off');
elseif iNumDevice > 0
    set(handles.GPU,'Visible','on')
    DataGPU =  gpuDevice;
    dTotalMemory = round(DataGPU.TotalMemory./1000000000); %%% Take 1 or 2 or 3 and so on
    %---------------- Check the memory to guide the user -----------------%
    if (dTotalMemory == 1)
       set(handles.Warning, 'Visible','on')
       set(handles.Warning, 'String', '1 GigaBytes of RAM are available in the GPU card: the suggested number of particles are between 1 and 3000 and the number of blocks between 1 and 10');
       set(handles.Warning, 'backgroundcolor',[1 0 0]); %%Red
    elseif (dTotalMemory == 2)
       set(handles.Warning, 'Visible','on')
       set(handles.Warning, 'String', ' 2 GigaBytes of RAM are available in the GPU card: the suggested number of particles are between 1 and 5000 and the number of blocks between 1 and 20');
       set(handles.Warning, 'backgroundcolor',[1 1 0]); %%Yellow
    else
       set(handles.Warning, 'Visible','on')
       set(handles.Warning, 'String', 'More then 2 GigaBytes of RAM are available in the GPU card: large number of particles (e.g 10000) and blocks (e.g. 30) are available');
       set(handles.Warning, 'backgroundcolor',[0 1 0]); %%Green
    end
end
%%---------------------- Initialization of the values -------------------%%
set(handles.ratio, 'Visible', 'off');
set(handles.ratiotext, 'Visible', 'off');
set(handles.learning, 'Value', 0);%%% Disable the Learning option       %%% 
set(handles.Estimate, 'Value', 0);%%% Disable the Sigma Lambda estimate %%%
set(handles.Plot, 'Value', 1);    %%% Select plot at the start up       %%%
set(handles.Tau,'Visible','off');  %%% Disable the tau ratio  %%%
set(handles.Lambda,'Visible','off');  %%% Disable the Lambda ratio  %%%
set(handles.text5,'Visible','off');  %%% Disable the tau text    %%%
set(handles.text6,'Visible','off');  %%% Disable the lambda ratio  %%%
%%---------------------- Populate the List box --------------------------%%
popup_sel_name = get(handles.ListDataFile, 'String');
if (isempty(popup_sel_name) == 1) 
      set(handles.uitable3, 'Data',  NaN .* ones(1, 2));  
else
    popup_sel_index = get(handles.ListDataFile, 'Value');
    sFileName = popup_sel_name{popup_sel_index};
    load(num2str(strcat('Dataset/',sFileName)));
    [~, ~, iL, ~] = size(mX);
    set(handles.uitable3, 'Data',  0.3 .* ones(iL, 2));% --- Load default values --- %
end
% --- Outputs from this function are returned to the command line.
function varargout = DeCo_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Get default command line output from handles structure
varargout{1} = handles.output;

%%% ----------- Executes on selection change in ListDataFile -----------%%%
%%% ----------- And populate the tables for the value of L and G -------%%%
function ListDataFile_Callback(hObject, eventdata, handles)
% hObject    handle to ListDataFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%%% ------------------------ Populate the table ----------------------- %%%
popup_sel_name = get(handles.ListDataFile, 'String');
popup_sel_index = get(handles.ListDataFile, 'Value');
sFileName = popup_sel_name{popup_sel_index};
%%% --------------------- Load the elements --------------------------- %%%
load(num2str(strcat('Dataset/', sFileName)));
[~, ~, iL, ~] = size(mX);
set(handles.uitable3, 'Data', 0.3 .* ones(iL, 2)); % ---- Load default values --- %

% --- Executes during object creation, after setting all properties. -----%
% --- This reads the dataset files available in the directory ------------%
function ListDataFile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ListDataFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
names = dir('Dataset/*.mat');
%%%%%%%%%%%%%%% Get the number of available dataset   %%%%%%%%%%%%%%%%%%%%%
iNumFiles = size(names, 1);
vSeriesName = cell(1, iNumFiles);
for i = 1:iNumFiles
    vSeriesName{i} = num2str(names(i).name);
end
%%% ----------------------- Populate the list box --------------------- %%%
set(hObject, 'String', vSeriesName);

% ------- Set the values for the estimation of Sigma and Lambda --------- %
function Estimate_Callback(hObject, eventdata, handles)
    iEstimate = get(handles.Estimate, 'Value');
    if (iEstimate == 0) 
       set(handles.ratio,'Visible','off');  %%% Disable the box ratio  %%%
       set(handles.ratiotext,'Visible','off');  %%% Disable the box ratio  %%%
    else
        set(handles.ratio,'Visible','on')
        set(handles.ratiotext,'Visible','on');  %%% Disable the box ratio  %%%
    end
    
% ------------- Set the values for the estimation of Sigma and Lambda --- %
function learning_Callback(hObject, eventdata, handles)
    iLearning = get(handles.learning, 'Value');
    if (iLearning == 0) 
       set(handles.Tau,'Visible','off');  %%% Disable the tau ratio  %%%
       set(handles.Lambda,'Visible','off');  %%% Disable the Lambda ratio  %%%
       set(handles.text5,'Visible','off');  %%% Disable the tau text    %%%
       set(handles.text6,'Visible','off');  %%% Disable the lambda ratio  %%%
    else
        set(handles.Tau,'Visible','on');
        set(handles.Lambda,'Visible','on');  %%% Disable the Lambda ratio  %%%
        set(handles.text5,'Visible','on');  %%% Disable the tau text    %%%
        set(handles.text6,'Visible','on');  %%% Disable the lambda ratio  %%%
    end   
    
% ------------------- Executes on button press in CPU. ------------------ %
function CPU_Callback(hObject, eventdata, handles)
% hObject    handle to CPU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
popup_sel_name = get(handles.ListDataFile, 'String');
popup_sel_index = get(handles.ListDataFile, 'Value');
sFileName = popup_sel_name{popup_sel_index};
%%%%%%%%%%%%%%%%% Take values from the program %%%%%%%%%%%%%%%%%
load(num2str(strcat('Dataset/', sFileName)));
cN = str2num(get(handles.NumberOfParticles, 'String'));
iDraws = str2num(get(handles.BlockNumber, 'String'));
%%--------------------- Set the value of the variables ------------------%%
iSave = get(handles.Save, 'Value');               %% Save or not? %%
iPlot = get(handles.Plot, 'Value');               %% Plot or not? %%
iLearning = get(handles.learning, 'Value');       %% Learning or not ?%%
iEstimate = get(handles.Estimate, 'Value');       %% Estimate or not Lambda Sigma %%
iTau = str2num(get(handles.Tau, 'String'));       %% Set the tau %%
dKappa  = str2num(get(handles.kappa, 'String'));  %% Set the kappa %%
dLambda = str2num(get(handles.Lambda, 'String')); %% Set the Lambda %%
dVar = str2num(get(handles.ratio, 'String'));     %% Take the variance %%
% -------------------- Options Estimate --------------------------------- %
if iEstimate == 1
     if all((dVar == 0)&(isempty(dVar) == 1))
         dVar = 0.01;
     end
else
    dVar = 0;
end
% ------------------------- End option learning ------------------------- %
mDataRand = get(handles.uitable3, 'Data');
run 'CodeCPU/MainPFIterCPU'   %%% execute the CPU code %%%

% --- Executes on button press in GPU. --- %
function GPU_Callback(hObject, eventdata, handles)
% hObject    handle to GPU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
popup_sel_name = get(handles.ListDataFile, 'String');
popup_sel_index = get(handles.ListDataFile, 'Value');
sFileName = popup_sel_name{popup_sel_index};
%%%%%%%%%%%%%%%%% Call the Program %%%%%%%%%%%%%%%%%
load(num2str(strcat('Dataset/', sFileName)));  %%% Path %%%%
cN = str2num(get(handles.NumberOfParticles, 'String'));
iDraws = str2num(get(handles.BlockNumber, 'String'));
%%--------------------- Set the value of the variables ------------------%%
iSave = get(handles.Save, 'Value');               %% Save or not? %%
iPlot = get(handles.Plot, 'Value');               %% Plot or not? %%
iLearning = get(handles.learning, 'Value');       %% Learning or not ?%%
iEstimate = get(handles.Estimate, 'Value');       %% Estimate or not Lambda Sigma
iTau = str2num(get(handles.Tau, 'String'));       %% Set the tau %%
dKappa  = str2num(get(handles.kappa, 'String'));  %% Set the kappa %%
dLambda = str2num(get(handles.Lambda, 'String')); %% Set the Lambda %%
dVar = str2num(get(handles.ratio, 'String'));     %% Take the variance %%
%% -------------------- Options Estimate ------------------------------- %%
if iEstimate == 1
     if all((dVar == 0)&(isempty(dVar) == 1))
         dVar = 0.01;
     end
else
    dVar = 0;
end
mDataRand = get(handles.uitable3, 'Data');
run 'CodeGPU/MainPFIterGPU'   %%% Running the GPU code %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% EOF %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%