%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                   Update the quantities of the states
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SStaNew = UpdateStaCPU(SSta0, S, Setting)
    SStaNew = SSta0;
    for i = 1:Setting.iL
       SStaNew.mSigmaFilt(S.t, i) = mean(S.mSigma(:, i), 1);
       SStaNew.mLambdaFilt(S.t, :, i) = mean(S.mLambda(:, :, i), 1);
       SStaNew.mXFilt(S.t, :, i) = mean(S.mOmega(:, :, i), 1);
       SStaNew.mYPred(S.t, 1, i) = median(S.ytilde(:, i));
       SStaNew.mYPred(S.t, 2, i) = quantile(S.ytilde(:, i), 0.025);
       SStaNew.mYPred(S.t, 3, i) = quantile(S.ytilde(:, i), 0.975); 
    end
end