%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%              Particle initalization with the regression 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S] = initPSCPU(Setting, vY, mXInit)
    w0 = ones(Setting.cN, 1)/Setting.cN;
    mOmega = zeros(Setting.cN, Setting.iDimOmega, Setting.iL);
    mOmegaTemp = zeros(Setting.cN, Setting.iDimOmega, Setting.iL);
    mLambda = zeros(Setting.cN, Setting.iDimOmega, Setting.iL);
    loglik0 = ones(Setting.cN, 1);
    mSigma =  repmat(Setting.vSigma', Setting.cN, 1) + Setting.iEstimate .* randn(Setting.cN, Setting.iL);
    ytilde0 = zeros(Setting.cN, Setting.iL);
    for i = 1:Setting.iL
           mOmegaTemp(:, :, i) = ones(Setting.cN, 1) * (mXInit(:, :, i)\vY(:,i))'; 
           mOmega(:, :, i) = mOmegaTemp(:, :, i) + exp(Setting.Sigma(1, 1)) * randn(Setting.cN, Setting.iDimOmega);
           mLambda(:, :, i) =  repmat(Setting.Sigma(i, :), Setting.cN, 1)  + ...
               Setting.iEstimate .* randn(Setting.cN, Setting.iDimOmega);
    end 
    S = struct('t', 0, 'w', w0, 'ytilde', ytilde0, 'loglik', ...
        loglik0, 'mOmega', mOmega, 'mSigma', mSigma, 'mLambda', mLambda);
end