%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%               Plotting the results 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function FiguresGPU (TrueweightsCumRange,  mSigma, mLambda, mYPred, Setting, iSave)
    fs = 10;    
    for i = 1:Setting.iL
        figure(i);
        set(gcf, 'name', ['Combination Weights series number ', mat2str(i)]);
        subplot(3, 2, 1);
        set(gca, 'FontSize', fs);
        title(strvcat(['w_i_t for GDP']),'FontSize', fs);
        fill([(1:1:Setting.cT)'; (Setting.cT:-1:1)'],[TrueweightsCumRange(:, 1, 1, i);...
            TrueweightsCumRange((Setting.cT:-1:1), 1, 2, i)],[0.9 0.9 0.9]);
        hold on;
        plot((1:1:Setting.cT)', TrueweightsCumRange(:, 1, 4, i), '-r', 'LineStyle', '-', 'LineWidth', 2);
        axis([1 Setting.cT 0 1]);
        set(gca, 'XTick', [1:20:Setting.cT,Setting.cT]);
        set(gca, 'XTickLabel', [1:20:Setting.cT,Setting.cT]);
        for kk = 2:Setting.iDimOmega;
            hold on;
            subplot(3, 2, kk);
            if kk<=3
                fill([(1:1:Setting.cT)'; (Setting.cT:-1:1)'],[TrueweightsCumRange(:,kk, 1, i);...
                    TrueweightsCumRange((Setting.cT:-1:1), kk, 2, i)],[0.9 0.9 0.9]);
                hold on;
                hf = plot((1:1:Setting.cT)', TrueweightsCumRange(:, kk, 4, i), '-r', 'LineStyle', '-', 'LineWidth', 2);
                hold off;
            else
                fill([(1:1:Setting.cT)'; (Setting.cT:-1:1)'],[TrueweightsCumRange(:,kk, 1, i);...
                    TrueweightsCumRange((Setting.cT:-1:1), kk, 2, i)],[0.9 0.9 0.9]);
                hold on;
                hf = plot((1:1:Setting.cT)', TrueweightsCumRange(:, kk, 4, i), '-r', 'LineStyle','-', 'LineWidth', 2);
                hold off;
            end
            set(gca, 'FontSize', fs);
            axis([1 Setting.cT 0 1]);
            set(gca, 'XTick', [1:20:Setting.cT,Setting.cT]);
            set(gca, 'XTickLabel', [1:20:Setting.cT,Setting.cT]);
            if iSave==1
                name=sprintf('../OutputGPU/Weights_series_%s.pdf',num2str(i));
                saveas(gcf,name);
            end
        end
        hold off;
        set(gca, 'XTick', [1:20:Setting.cT,Setting.cT]);
        set(gca, 'XTickLabel', [1:20:Setting.cT,Setting.cT]);
    end

    for i = Setting.iL+1:2*Setting.iL
        figure(i);
        set(gcf, 'name', ['Predictive Densities series number ' mat2str(i - Setting.iL)]);
        A = squeeze(mean(mYPred(:, 2, i - Setting.iL, :), 4));
        fill([(1:1:Setting.cT)'; (Setting.cT:-1:1)'],[squeeze(mean(mYPred(:,3,i - Setting.iL,:),4));...
            A(end:-1:1)],[0.9 0.9 0.9]);hold on;
        plot(squeeze(mean(mYPred(:,1,i - Setting.iL,:), 4)), '-r', 'LineWidth', 2);hold on;
        plot(squeeze(mean(mYPred(:,2,i - Setting.iL,:), 4)), '-k', 'LineWidth', 1);hold on;
        plot(squeeze(mean(mYPred(:,3,i - Setting.iL,:), 4)), '-k', 'LineWidth', 1);hold off;
        set(gca, 'XTick', [1:20:Setting.cT,Setting.cT]);
        set(gca, 'XTickLabel', [1:20:Setting.cT,Setting.cT]);
        if iSave==1
            name=sprintf('../OutputGPU/Predictive_densities_series_%s.pdf',num2str(i-Setting.iL));
            saveas(gcf,name);
        end
    end
    %%%------------------- Plot the mSigma and mLambda -------------------%%%
    if Setting.iEstimate >0
        for i = 1:Setting.iL
            figure(2*Setting.iL+i);
            set(gcf, 'name', ['Estimated Sigma and Lambda series number ', mat2str(i)]);
            subplot(2, 1, 1);
            set(gca, 'FontSize', fs);
            plot(exp(mLambda(:, :, i)));
            subplot(2, 1, 2);
            plot(exp(mSigma(:, i)));
        end
    end
end