%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%           Function that execute the core PF and resampling at 
%           time t
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S] = Resample_MoveGPU(S, Setting, vY, mXTot, vErrorTot)
    %%%%%%%%%%%%%%%%%%%%%% Call the PF function %%%%%%%%%%%%%%%%%%%%%%%%%%%
    [S] = PFCoreGPU(S, Setting, vY, mXTot, vErrorTot);
    %%%%%%%%%%%%%%%%%%%%%%%% Normalized weigth %%%%%%%%%%%%%%%%%%%%%%%%%%%%
    mTemp = reshape(S.w, Setting.iDraws, Setting.cN);
    mTemp = mTemp ./Kronbsxfun(gpuArray.ones(1, Setting.cN), sum(mTemp, 2));
    S.dEss = 1./sum(mTemp.^2, 2)./Setting.cN;
    % ------------------ Pass back to the CPU to perform resampling ----- %
    [mResamplingParticle, mResamplingParticleY] = EmpGPU(gather(mTemp), ...
       gather(Setting.cN), gather(Setting.iDraws), gather(Setting.iDimOmega), ...
       gather(Setting.iL), gather(S.dEss), gather(Setting.dKappa));
    % ------------------------- Return to GPU --------------------------- %
    mResamplingParticle = gpuArray(mResamplingParticle);
    mResamplingParticleY = gpuArray(mResamplingParticleY);
    % --------------------- Resampling states - Omega ------------------- %
    for i = 1:gather(Setting.iL)
          mHelp = reshape(S.mOmega(:, :, i), Setting.iDraws, Setting.cN * Setting.iDimOmega)';   
          mHelp = reshape(mHelp(:), Setting.cN, Setting.iDimOmega * Setting.iDraws);
          mHelp = mHelp(:);
          mHelp = mHelp(mResamplingParticle(:));
          mHelp = reshape(mHelp, Setting.cN, Setting.iDimOmega * Setting.iDraws);
          S.mOmega(:, :, i) = reshape(mHelp',  Setting.iDimOmega, Setting.iDraws * Setting.cN)';
          mHelp = reshape(S.mLambda(:, :, i), Setting.iDraws, Setting.cN * Setting.iDimOmega)';   
          mHelp = reshape(mHelp(:), Setting.cN, Setting.iDimOmega * Setting.iDraws);
          mHelp = mHelp(:);
          mHelp = mHelp(mResamplingParticle(:));
          mHelp = reshape(mHelp, Setting.cN, Setting.iDimOmega * Setting.iDraws);
          S.mLambda(:, :, i) = reshape(mHelp',  Setting.iDimOmega, Setting.iDraws * Setting.cN)';    
    end
    %%%%%%%%%%%%%%%%%%%%  Resampling y_t %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    mHelp = reshape(S.ytilde, Setting.iDraws, Setting.cN * Setting.iL)';   
    mHelp = reshape(mHelp(:), Setting.cN, Setting.iL * Setting.iDraws);
    mHelp = mHelp(:);
    mHelp = mHelp(mResamplingParticleY(:));
    mHelp = reshape(mHelp, Setting.cN, Setting.iL * Setting.iDraws);
    S.ytilde = reshape(mHelp',  Setting.iL, Setting.iDraws * Setting.cN)';
    %%%%%%%%%%%%%%%%%%%%  Resampling mSigma %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    mHelp = reshape(S.mSigma, Setting.iDraws, Setting.cN * Setting.iL)';   
    mHelp = reshape(mHelp(:), Setting.cN, Setting.iL * Setting.iDraws);
    mHelp = mHelp(:);
    mHelp = mHelp(mResamplingParticleY(:));
    mHelp = reshape(mHelp, Setting.cN, Setting.iL * Setting.iDraws);
    S.mSigma = reshape(mHelp', Setting.iL, Setting.iDraws * Setting.cN)';
    clear mHelp;
    %%%%%%%%%%%%%%%%%%%%  Reset the weights %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    S.w = gpuArray.ones(Setting.cN * Setting.iDraws, 1)/(Setting.cN);
    %%%%%%%%%%%%%%%%%% Create the right structure after resampled %%%%%%%%%
    S = struct('t', S.t, 'w', S.w, 'mOmega', S.mOmega, ...
        'ytilde', S.ytilde, 'mSigma', S.mSigma, 'mLambda', S.mLambda);
    clear mResamplingParticle;
end