%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%           Function that initialize the particles on GPU 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S] = initPSGPU(Setting, mYGPU, mXGPU)
    %%%%%%%%%%%%%%%%%%%%%%% Allocation data on GPU %%%%%%%%%%%%%%%%%%%%%%%%
    vW0 = gpuArray.ones(Setting.cN * Setting.iDraws, 1)/(Setting.cN);
    mYtilde0 = gpuArray.zeros(Setting.cN * Setting.iDraws, Setting.iL);
    mOmegaTemp = gpuArray.zeros(Setting.iDraws, Setting.iDimOmega, Setting.iL);
    mOmega = gpuArray.zeros(Setting.cN * Setting.iDraws, Setting.iDimOmega, Setting.iL);
    mLambda = gpuArray.zeros(Setting.cN * Setting.iDraws, Setting.iDimOmega, Setting.iL);
    mSigma = repmat(Setting.vSigma, Setting.cN * Setting.iDraws, 1) + Setting.iEstimate .* gpuArray.randn(Setting.cN * Setting.iDraws, Setting.iL);
    %%%%%%%%%%%%%%%%%%%%%%% Execute calculation on GPU %%%%%%%%%%%%%%%%%%%%
    mMatrixHelp = Kronbsxfun(gpuArray.ones(Setting.iDraws, 1), gpuArray.eye(Setting.iDimOmega));
    mTemp = reshape(Setting.Sigma, Setting.iDimOmega, Setting.iL)';
    for i = 1:Setting.iL
       mOmegaTemp(:, :, i) = (mXGPU(:, :, i)\mYGPU(:, :, i))' * mMatrixHelp;
       mOmega(:, :, i) = Kronbsxfun(gpuArray.ones(Setting.cN, 1), mOmegaTemp(:, :, i)) ...
        + exp(Setting.Sigma(1, 1)) * gpuArray.randn(Setting.cN * Setting.iDraws, Setting.iDimOmega);
       mLambda(:, :, i) = Kronbsxfun(gpuArray.ones(Setting.cN * Setting.iDraws, 1), ...
           mTemp(i, :))+ Setting.iEstimate .* gpuArray.randn(Setting.cN * Setting.iDraws, Setting.iDimOmega);
    end
    clear mMatrixHelp mOmegaTemp;
    %%%%%%%%%%%%%%%%% Create the Structure on the GPU %%%%%%%%%%%%%%%%%%%%%
    S = struct('t', 0,'w', vW0, 'ytilde', mYtilde0, 'mOmega', mOmega, 'mSigma', mSigma, 'mLambda', mLambda);
 end