%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       Initialize state for the particle filter 
%       Note that we have to consider the numer of simulations
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [SSta] = initStaGPU(Setting)
    mXFilt = gpuArray.zeros(Setting.iDraws * Setting.iDimOmega, Setting.cT, Setting.iL);
    mYPred = gpuArray.zeros(Setting.cT, Setting.cN * Setting.iDraws, Setting.iL);
    mSigmaFilt = gpuArray.zeros(Setting.cT, Setting.iL);
    mLambdaFilt =  gpuArray.zeros(Setting.cT, Setting.iDimOmega, Setting.iL);
    SSta = struct('mXFilt', mXFilt, 'mYPred', mYPred, 'mSigmaFilt', mSigmaFilt,'mLambdaFilt', mLambdaFilt);
end