%                        Empirical Density Function          
% Simulate Empirical Density F. given weights and values     
% m represents the number of bootstrapped values             
function x = EmpCPU(w, M)
  su = sum(w);
  dist = cumsum(w/su);
  u = unifrnd(0,1,M,1);
  x = zeros(M,1);
    for i=1:1:M
        x(i,1)=sum(dist<(u(i,1)*ones(M,1)))+1;
    end
end
