%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%           Function that execute the core PF at time t
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S] = PFCoreGPU(S, Setting, vY, mXTot, vErrorTot)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %                        Learning mechanism                           %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if Setting.iTau>0
       if S.t<=(Setting.iTau + 1);            
       else
          for j=1:gather(Setting.iTau)
             for z = 1:gather(Setting.iL)
                 S.mOmega(:, :, z) =  (S.mOmega(:, :, z)' - (1 - Setting.dLambda) * Setting.dLambda^(j - 1) * ...
                 reshape(Kronbsxfun(gpuArray.ones(1, Setting.cN), (vErrorTot(S.t, :, z) - ...
                 vErrorTot(S.t - 1, :, z))), Setting.iDimOmega, Setting.iDraws * Setting.cN))';
             end
          end
       end
    end
    clear vErrorTot;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %           A1 B1|A1 B1    iDraws = 2
    %           A2 B2|A2 B2    iDimOmega = 6
    %           A3 B3|A3 B3    iParticle = 2
    %           *****|*****
    %           A6 B6|A6 B6
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%-------------------- Update the mOmega states -------------------%%%
    mParticleTemp = reshape(S.mOmega, Setting.cN * Setting.iDraws, Setting.iDimOmega * Setting.iL)'+ ...
        exp(0.5 * reshape(S.mLambda, Setting.cN * Setting.iDraws, Setting.iDimOmega * Setting.iL)')...
        .* gpuArray.randn(Setting.iDimOmega * Setting.iL, Setting.iDraws * Setting.cN); 
    S.mOmega = reshape(mParticleTemp', Setting.cN * Setting.iDraws, Setting.iDimOmega, Setting.iL);
    clear mParticleTemp;
    %%%-------------------- Update the mLambda states ------------------%%%
    S.mLambda = S.mLambda + Setting.iEstimate.*gpuArray.randn(Setting.iDraws * ...
        Setting.cN, Setting.iDimOmega, Setting.iL);
    %%%------------------- Update the mSigma states --------------------%%%
    S.mSigma = S.mSigma + Setting.iEstimate .* gpuArray.randn(Setting.iDraws * Setting.cN, Setting.iL);
    %%%%%%%%%%%%%%%%%%%%%%%%% Calculate the LogLik %%%%%%%%%%%%%%%%%%%%%%%%% 
    vLogLik = 0;
    for i = 1:gather(Setting.iL)
       %---------------------- Calculate the Y tilde ---------------------%
       S.ytilde(:, i) = sum(logmulGPU(S.mOmega(:, :, i), Setting) .* Kronbsxfun(gpuArray.ones(Setting.cN, 1), ...
       reshape(mXTot(:, S.t, i), Setting.iDimOmega, Setting.iDraws)'), 2) + ...
       exp(0.5 * S.mSigma(:, i)) .* gpuArray.randn(Setting.iDraws * Setting.cN, 1);
       %---------------------- Calculate the likelihood ------------------%
       vLogLik = vLogLik - 0.5 * log(exp(S.mSigma(:, i)) * pi) ...
        - 0.5 * ((gpuArray.ones(Setting.iDraws * Setting.cN, 1).* vY(S.t, i) - ...
        sum(logmulGPU(S.mOmega(:, :, i), Setting) .* Kronbsxfun(gpuArray.ones(Setting.cN, 1), ...
       reshape(mXTot(:, S.t, i), Setting.iDimOmega, Setting.iDraws)'), 2)) .* ...
       (gpuArray.ones(Setting.iDraws * Setting.cN, 1).* vY(S.t, i) ...
       - sum(logmulGPU(S.mOmega(:, : ,i), Setting) .* Kronbsxfun(gpuArray.ones(Setting.cN, 1), ...
       reshape(mXTot(:, S.t, i), Setting.iDimOmega, Setting.iDraws)'), 2)))./exp(S.mSigma(:, i));
    end
    %%%%%%%%%%%%%%%%%%%%%%%% Calculate the weights %%%%%%%%%%%%%%%%%%%%%%%%% 
    S.w = exp(log(S.w) + vLogLik);
    clear vLogLik;
end