/* logit model with Cauchy priors */
data {
  int<lower=1> K;
  int<lower=K> N;
  matrix[N,K] X;
  int<lower=0,upper=1> y[N];
  real<lower=0> gamma;
}
parameters {
  vector[K] beta;
}
model {
  vector[N] eta;
  eta <- X * beta;
  
  # likelihood
  /* worst possible way: 
  N individual function calls
  unstable transformation
  cancellation
  for (i in 1:N) {
    y[i] ~ bernoulli( 1.0 / (1.0 + exp(-eta[i])) );
  }
  
  next worst way: 
  N individual function calls
  stable transformation
  cancellation
  for (i in 1:N) {
    y[i] ~ bernoulli( inv_logit(eta[i]) );
  }
  
  next worst way:
  N individual function calls
  stable transformation
  no cancellation
  for (i in 1:N) {
    y[i] ~ bernoulli_logit(eta[i]);
  }
  
  best way:
  1 function call
  stable transformation
  no cancellation 
  */
  y ~ bernoulli_logit(eta);  # assumes y[i] is independent given eta[i]
  beta ~ cauchy(0.0, gamma); # independent Cauchy priors
}
