library(MASS)
library(rstan)
data(housing)

house.plr <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)
X <- model.matrix(house.plr)[,-1] # no intercept
N <- nrow(X)
K <- ncol(X)
y <- as.integer(housing$Sat)
J <- length(unique(y))
w <- housing$Freq
gamma <- 5

stan_rdump(c("K", "N", "J", "X", "y", "w", "gamma"), file = "ologit.data.R")
