library(rstan)
data(sunspots)

y <- as.integer(round(sunspots))
N <- length(y)
mean(y == 0)

stan_rdump(c("N", "y"), file = "poisson.data.R")

# very slow because N + 2 parameters to estimate
posterior <- stan(file = "poisson.stan", data = list(N = N, y = y), 
                  chains = 8, refresh = 10)

