/* ordinal logit model with Cauchy priors */
data {
  int<lower=1> K;
  int<lower=K> N;
  int<lower=3> J;
  matrix[N,K] X; // NO INTERCEPT
  int<lower=1,upper=J> y[N];
  real<lower=0> w[N]; // weights
  real<lower=0> gamma; // scale
}
parameters {
  vector[K] z;
  ordered[J-1] zeta;
}
transformed parameters {
  vector[K] beta;
  for (k in 1:K) { # inverse CDF for Cauchy
    beta[k] <- gamma * tan( pi() * (Phi_approx(z[k]) - 0.5) );
  }
}
model {
  vector[N] eta;
  eta <- X * beta;
  
  # likelihood, have to do it the slow way because of the weights
  for (i in 1:N) {
    increment_log_prob( w[i] * ordered_logistic_log(y[i], eta[i], zeta) );
  }
  z ~ normal(0.0, 1.0); // implies beta ~ cauchy(0,gamma)
}
