library(rstan)
source("poisson.data.R")
ls()

# very slow because N + 2 parameters to estimate, so do in parallel
posterior <- stan(file = "poisson.stan", data = list(N = N, y = y), 
                  chains = 0)
library(parallel)
posterior <- sflist2stanfit(mclapply(1:8, mc.cores = 8, FUN = function(i) {
  stan(fit = posterior, data = list(N = N, y = y), chains = 1, chain_id = i,
       seed = 12345, refresh = 10 * (i == 1))
}))
print(posterior)
