griliches <- read.csv("griliches.csv")
griliches$YEAR <- as.factor(griliches$YEAR) # treats YEAR as categorical
griliches$AGE2 <- griliches$AGE^2
ols2 <- lm(LW ~ S + EXPR + TENURE + RNS + SMSA + YEAR + AGE + AGE2, 
           data = griliches)
griliches$AGE802 <- griliches$AGE80^2
X <- model.matrix(ols2)
X <- X[,-c(7:12)] # drop year variables
X[,"AGE"] <- griliches$AGE80
X[,"AGE2"] <- griliches$AGE802

A_0 <- t(X) %*% X
beta_0 <- coef(ols2)[-c(7:12)]
beta_0[1] <- 5
N <- nrow(X)
K <- ncol(X)
v_0 <- N - K
s2_0 <- sum(residuals(ols2)^2)

X <- model.matrix(LW80 ~ S80 + EXPR80 + TENURE80 + RNS80 + SMSA80 + AGE80 + AGE802, 
                  data = griliches)
y <- griliches$LW80

library(rstan)
stan_rdump(list("K", "N", "X", "y", "beta_0", "A_0", "v_0", "s2_0"),
           file = "regression.data.R")

