/* zero inflated poisson with autoregression */
data {
  int<lower=1> N;
  int<lower=0> y[N];
}
parameters {
  vector[N] z;
  real<lower=0> sigma;
  real lambda_log;
}
model {
  real theta_log;
  theta_log <- 0.0;
  for (n in 1:N) {
    theta_log <- theta_log + sigma * z[n];
    if (y[n] == 0) {
      increment_log_prob( log_sum_exp(bernoulli_logit_log(1, theta_log), 
                                      bernoulli_logit_log(0, theta_log) + 
                                      poisson_log_log(y[n], lambda_log)) );
    }
    else {
      increment_log_prob( bernoulli_logit_log(0, theta_log) + 
                          poisson_log_log(y[n], lambda_log) );
    }
  }
  
  // priors
  z ~ normal(0.0, 1.0); # implies theta ~ normal(lag(theta), sigma)
  sigma ~ cauchy(0.0, 5.0);
  // implicit: lambda_log ~ uniform over R
}
