function [records] = Sim_large(matrix_name,varargin)
% Parse input
argin = inputParser;
argin.addRequired('matrix_name');
argin.addParamValue('choice','svd',@(x) ischar(x));
argin.addParamValue('rep',1,@(x) x>0);
argin.addParamValue('seed',2014,@(x) x>0);
argin.addParamValue('rank',10,@(x) x>0);
argin.addParamValue('kth',50,@(x) x>0);
argin.addParamValue('load',false,@(x) islogical(x));
argin.parse(matrix_name,varargin{:});

choice = argin.Results.choice;
rep = argin.Results.rep;
seed = argin.Results.seed;
rank = argin.Results.rank;
kth = argin.Results.kth;
load = argin.Results.load;

s = RandStream('mt19937ar','Seed',seed);      % Reproducible
RandStream.setGlobalStream(s);                            

if (load)
    data = load('matrix_name'); % not work
    %data = Mat.Problem.A;           
else
    data = matrix_name;
end

% Basic feature about the sparse matrix
fprintf('The size of the matrix is %d by %d\n',size(data,1),size(data,2) );
fprintf('The sparsity of the matrix is %d\n', ...
    1-nnz(data)/(size(data,1)*size(data,2)));

records = zeros(2,rep);            % Store the run time

switch choice 
    case 'svd' % vs svd for svt with structured matrix
        fprintf('Compared with svd for structured matrix svt:\n');
        m = size(data,1);
        n = size(data,2);
        l = randn(m,rank);  
        r = randn(n,rank);
        lr = l*r';           % Generation of low rank
        MA = data;
        new_data = MA + lr;    % Sparse + low rank
        
        lambdas = svds(new_data,kth);
        tau = lambdas(kth);
        fprintf('lambda is: %d\n',tau);
        
        for j = 1:rep
           tic;
           [u,s,v] = svt(@MAtimesVec,'lambda',tau,'m',m,'n',n);
           records(1,j) = toc;
%            fprintf('Accuracy of svt: %d\n', ...
%                norm(new_data-u*s*v','fro')/norm(new_data,'fro'));

%            tic;
%            [fu,fs,fv] = svd(full(new_data));
%            fs = diag(fs);
%            i = find(fs<=tau);
%            fu = fu(:,1:i-1);
%            fs = fs(1:i-1);
%            fv = fv(:,1:i-1);
%            fs = diag(fs);
%            records(2,:) = toc;
%            fprintf('Accuracy of full svd for svt: %d\n', ...
%                norm(new_data-fu*fs*fv','fro')/norm(new_data,'fro'));
       end
        
    case 'svt' % only svt for very large sparse matrix
        fprintf('Only svt for very large sparse matrix:\n');
        
        lambdas = svds(data,kth);
        tau = lambdas(kth);
        fprintf('lambda is: %d\n',tau);

        for j = 1:rep
           tic;
           [su,ss,sv] = svt(data,'lambda',tau);
           records(1,j) = toc;
%            fprintf('Accuracy of svt not exploiting structure: %d\n', ...
%                norm(data-su*ss*sv','fro')/norm(data,'fro')); % not needed
        end    
end
    
records = records(:,1:rep)';

fprintf('The mean of run time of svt is %d\n',mean(records(:,1)));
fprintf('The mean of run time of objective function is %d\n', ...
    mean(records(:,2)));
fprintf('\n');


function MAvec = MAtimesVec(vec, trans) % Subfunction input by user 
    if trans
       MAvec = (vec'*MA)' + r*(vec'*l)';
    else
       MAvec = MA*vec + l*(r'*vec);
    end    
end


end