%% comparison with svd 
% singular value thresholding on large-scale matrix
clear;

% simulation settings 
rep = 1; 
seed = 2014;

% m << n structured matrices
load('bibd_20_10.mat');              % 190 by 184756
bibd_20_10 = Problem.A;
load('bibd_22_8.mat');               % 231 by 319770
bibd_22_8 = Problem.A;

% Very large sparse matrices
load('stormG2_1000.mat');           % 528185 by 1377306
stormG2_1000 = Problem.A;
load('tp-6.mat');                    % 142752 by 1014301
tp6 = Problem.A;

% keeper of results 
records1 = zeros(3,4);
k = [5,20,50];             % three k   
% use Sim_large function to conduct comparison

for j = 1:3
    
records = Sim_large(bibd_20_10,'choice','svd','rep',rep,'seed',seed,'kth',k(j));
records1(j,1) = records(:,1); % collect svt results

records = Sim_large(bibd_22_8,'choice','svd','rep',rep,'seed',seed,'kth',k(j));
records1(j,2) = records(:,1); % collect svt results

records = Sim_large(stormG2_1000,'choice','svt','rep',rep,'seed',seed,'kth',k(j));
records1(j,3) = records(:,1); % collect svt results

records = Sim_large(tp6,'choice','svt','rep',rep,'seed',seed,'kth',k(j));
records1(j,4) = records(:,1); % collect svt results
end

records1 = records1 / 60;   % in minutes

% save data
save('ne10_svt.mat','records1');


