/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager;

import ca.pfv.spmf.algorithmmanager.AlgorithmManager;
import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;

public class MainTestAlgorithmManager {
    public static void main(String[] args) throws Exception {
        AlgorithmManager algoManager = AlgorithmManager.getInstance();
        System.out.println("========= Printing the list of algorithms sorted by categories ========");
        System.out.println();
        for (String algoName : algoManager.getListOfAlgorithmsAsString()) {
            System.out.println(algoName);
        }
        System.out.println();
        System.out.println("========= Obtaining information about the BIDE+ algorithm ========");
        String algorithm = "BIDE+";
        DescriptionOfAlgorithm descriptionOfAlgorithm = algoManager.getDescriptionOfAlgorithm(algorithm);
        System.out.println("Name : " + descriptionOfAlgorithm.getName());
        System.out.println("Category : " + descriptionOfAlgorithm.getAlgorithmCategory());
        System.out.println("Types of input file : " + Arrays.toString(descriptionOfAlgorithm.getInputFileTypes()));
        System.out.println("Types of output file : " + Arrays.toString(descriptionOfAlgorithm.getOutputFileTypes()));
        System.out.println("Types of parameters : " + Arrays.toString(descriptionOfAlgorithm.getParametersDescription()));
        System.out.println("Implementation author : " + descriptionOfAlgorithm.getImplementationAuthorNames());
        System.out.println("URL:  : " + descriptionOfAlgorithm.getURLOfDocumentation());
        System.out.println();
        System.out.println("========= Running the BIDE+ algorithm ========");
        String[] parameters = new String[]{"0.4", "50", "true"};
        String inputFile = MainTestAlgorithmManager.fileToPath("contextPrefixSpan.txt");
        String outputFile = "./output.txt";
        descriptionOfAlgorithm.runAlgorithm(parameters, inputFile, outputFile);
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestAlgorithmManager.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

