/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.cmrules.AlgoCMRules;
import java.io.IOException;

public class DescriptionAlgoCMRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CMRules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmrules";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoCMRules.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoCMRules.getParamAsDouble(parameters[1]);
        AlgoCMRules algo = new AlgoCMRules();
        algo.runAlgorithm(inputFile, outputFile, minsup, minconf);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential rules", "Frequent sequential rules"};
    }
}

