/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.AlgoCMSPADE;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.candidatePatternsGeneration.CandidateGenerator_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator_FatBitmap;
import java.io.IOException;

public class DescriptionAlgoCMSPADE
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CM-SPADE";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#cmspade";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AbstractionCreator_Qualitative abstractionCreator = AbstractionCreator_Qualitative.getInstance();
        IdListCreator idListCreator = IdListCreator_FatBitmap.getInstance();
        CandidateGenerator_Qualitative candidateGenerator = CandidateGenerator_Qualitative.getInstance();
        double minSupport = DescriptionAlgoCMSPADE.getParamAsDouble(parameters[0]);
        boolean outputSeqIdentifiers = false;
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            outputSeqIdentifiers = DescriptionAlgoCMSPADE.getParamAsBoolean(parameters[1]);
        }
        AlgoCMSPADE algo = new AlgoCMSPADE(minSupport, true, abstractionCreator);
        SequenceDatabase sd = new SequenceDatabase(abstractionCreator, idListCreator);
        sd.loadFile(inputFile, minSupport);
        algo.runAlgorithm(sd, candidateGenerator, true, false, outputFile, outputSeqIdentifiers);
        System.out.println(algo.printStatistics());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Antonio Gomariz Penalver & Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns"};
    }
}

