/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.charm.AlgoCharmMFI;
import ca.pfv.spmf.algorithms.frequentpatterns.charm.AlgoCharm_Bitset;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class DescriptionAlgoCharmMFI
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Charm_MFI";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#e3";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoCharmMFI.getParamAsDouble(parameters[0]);
        TransactionDatabase database = new TransactionDatabase();
        try {
            database.loadFile(inputFile);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AlgoCharm_Bitset charm = new AlgoCharm_Bitset();
        charm.runAlgorithm(null, database, minsup, false, 10000);
        AlgoCharmMFI charmMFI = new AlgoCharmMFI();
        charmMFI.runAlgorithm(outputFile, charm.getClosedItemsets());
        charmMFI.printStats(database.size());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Maximal patterns", "Maximal itemsets", "Frequent itemsets", "Frequent maximal itemsets"};
    }
}

