/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.tools.dataset_converter.Formats;
import ca.pfv.spmf.tools.dataset_converter.SequenceDatabaseConverter;
import java.io.IOException;

public class DescriptionAlgoConvertASequenceDBToSPMF
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Convert_a_sequence_database_to_SPMF_format";
    }

    @Override
    public String getAlgorithmCategory() {
        return "DATASET TOOLS";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#convseq";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String format = DescriptionAlgoConvertASequenceDBToSPMF.getParamAsString(parameters[0]);
        int seqCount = DescriptionAlgoConvertASequenceDBToSPMF.getParamAsInteger(parameters[1]);
        long startTime = System.currentTimeMillis();
        SequenceDatabaseConverter converter = new SequenceDatabaseConverter();
        converter.convert(inputFile, outputFile, Formats.valueOf(format), seqCount, null);
        long endTIme = System.currentTimeMillis();
        System.out.println("Sequence database converted.  Time spent for conversion = " + (endTIme - startTime) + " ms.");
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Input format", "(e.g. CSV_INTEGER)", String.class, false), new DescriptionOfParameter("Sequence count", "(e.g. 5)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Sequence database in non SPMF format"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }
}

