/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.tools.dataset_converter.Formats;
import ca.pfv.spmf.tools.dataset_converter.SequenceDatabaseConverter;
import java.io.IOException;
import java.nio.charset.Charset;

public class DescriptionAlgoConvertTEXTFileToSequenceDB
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Convert_TEXT_file_to_sequence_database";
    }

    @Override
    public String getAlgorithmCategory() {
        return "DATASET TOOLS";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#convtextfile";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int sequenceCount = DescriptionAlgoConvertTEXTFileToSequenceDB.getParamAsInteger(parameters[0]);
        Charset charset = PreferencesManager.getInstance().getPreferedCharset();
        long startTime = System.currentTimeMillis();
        SequenceDatabaseConverter converter = new SequenceDatabaseConverter();
        converter.convert(inputFile, outputFile, Formats.TEXT, sequenceCount, charset);
        long endTIme = System.currentTimeMillis();
        System.out.println("Sequence database converted.  Time spent for conversion = " + (endTIme - startTime) + " ms.");
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Sequence count count", "(e.g. 5)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Text file"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }
}

