/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.tools.dataset_converter.Formats;
import ca.pfv.spmf.tools.dataset_converter.SequenceDatabaseConverter;
import java.io.IOException;

public class DescriptionAlgoConvertTransactionDBSequenceDB
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Convert_transaction_database_to_sequence_database";
    }

    @Override
    public String getAlgorithmCategory() {
        return "DATASET TOOLS";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#convtransseq";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int sequenceCount = DescriptionAlgoConvertTransactionDBSequenceDB.getParamAsInteger(parameters[0]);
        long startTime = System.currentTimeMillis();
        SequenceDatabaseConverter converter = new SequenceDatabaseConverter();
        converter.convert(inputFile, outputFile, Formats.SPMF_TRANSACTION_DB, sequenceCount, null);
        long endTIme = System.currentTimeMillis();
        System.out.println("Transaction database converted.  Time spent for conversion = " + (endTIme - startTime) + " ms.");
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Sequence count count", "(e.g. 5)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }
}

