/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.dbscan.AlgoDBSCAN;
import java.io.IOException;

public class DescriptionAlgoDBScan
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "DBScan";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#dbscan";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minPts = DescriptionAlgoDBScan.getParamAsInteger(parameters[0]);
        double epsilon = DescriptionAlgoDBScan.getParamAsDouble(parameters[1]);
        AlgoDBSCAN algo = new AlgoDBSCAN();
        algo.runAlgorithm(inputFile, minPts, epsilon, " ");
        algo.printStatistics();
        algo.saveToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minPts", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("epsilon", "(e.g. 5)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Clusters", "Density-based clusters"};
    }
}

