/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoFEAT;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoFEAT
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FEAT";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#feat";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AlgoFEAT algo = new AlgoFEAT();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMaximumPatternLength(DescriptionAlgoFEAT.getParamAsInteger(parameters[1]));
        }
        SequenceDatabase sequenceDatabase = new SequenceDatabase();
        sequenceDatabase.loadFile(inputFile);
        int minsup = (int)(DescriptionAlgoFEAT.getParamAsDouble(parameters[0]) * (double)sequenceDatabase.size());
        boolean outputSeqIdentifiers = false;
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            outputSeqIdentifiers = DescriptionAlgoFEAT.getParamAsBoolean(parameters[1]);
        }
        algo.setShowSequenceIdentifiers(outputSeqIdentifiers);
        algo.runAlgorithm(sequenceDatabase, minsup);
        algo.writeResultTofile(outputFile);
        algo.printStatistics(sequenceDatabase.size());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "", Integer.class, true), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns", "Frequent sequential generators"};
    }
}

