/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoFHM_Freq;
import java.io.IOException;

public class DescriptionAlgoFHMFreq
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FHMFreq";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/documentation.php#fhmfreq";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoFHMFreq.getParamAsInteger(parameters[0]);
        double minsup = DescriptionAlgoFHMFreq.getParamAsDouble(parameters[1]);
        AlgoFHM_Freq algo = new AlgoFHM_Freq();
        algo.runAlgorithm(inputFile, outputFile, minutil, minsup);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 30)", Integer.class, false), new DescriptionOfParameter("Minimum support", "(e.g. 0.40)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "Frequent high-utility itemsets"};
    }
}

