/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.gcd.GCDAssociationRules;
import java.util.Calendar;

public class DescriptionAlgoGCDAssociationRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "GCD_association_rules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/documentation.php#gcd";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws Exception {
        double minsup = DescriptionAlgoGCDAssociationRules.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoGCDAssociationRules.getParamAsDouble(parameters[1]);
        int maxcomb = DescriptionAlgoGCDAssociationRules.getParamAsInteger(parameters[2]);
        GCDAssociationRules gcdRunner = new GCDAssociationRules(inputFile, outputFile, minsup, minconf, maxcomb);
        long start = Calendar.getInstance().getTimeInMillis();
        gcdRunner.runAlgorithm();
        long end = Calendar.getInstance().getTimeInMillis();
        long ms = end - start;
        System.out.println("-------");
        System.out.println("Number of rules found: " + gcdRunner.getPatternCount());
        System.out.println("Total in milliseconds: " + ms + " ms");
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Maxcomb (%)", "(e.g. 3)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Ahmed El-Serafy, Hazem El-Raffiee";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules"};
    }
}

