/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.Indirect.AlgoINDIRECT;
import java.io.IOException;

public class DescriptionAlgoIndirectAssociationRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Indirect_association_rules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/documentation.php#indirect";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoIndirectAssociationRules.getParamAsDouble(parameters[0]);
        double ts = DescriptionAlgoIndirectAssociationRules.getParamAsDouble(parameters[1]);
        double minconf = DescriptionAlgoIndirectAssociationRules.getParamAsDouble(parameters[2]);
        AlgoINDIRECT indirect = new AlgoINDIRECT();
        indirect.runAlgorithm(inputFile, outputFile, minsup, ts, minconf);
        indirect.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("TS", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.1 or 10%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Indirect association rules"};
    }
}

