/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.MNRRules.AlgoMNRRules;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.AlgoZart;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import java.io.IOException;

public class DescriptionAlgoMNRAssociationRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MNR";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/documentation.php#example21";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        System.out.println("STEP 1: APPLY ZART TO FIND CLOSED ITEMSETS AND GENERATORS");
        double minsup = DescriptionAlgoMNRAssociationRules.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoMNRAssociationRules.getParamAsDouble(parameters[1]);
        TransactionDatabase database = new TransactionDatabase();
        try {
            database.loadFile(inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AlgoZart zart = new AlgoZart();
        TZTableClosed results = zart.runAlgorithm(database, minsup);
        zart.printStatistics();
        System.out.println("STEP 2 : CALCULATING MNR ASSOCIATION RULES");
        AlgoMNRRules algoMNR = new AlgoMNRRules();
        algoMNR.runAlgorithm(outputFile, minconf, results, database.size());
        algoMNR.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.61 or 61%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Minimal non-redundant association rules"};
    }
}

