/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.pfpm.AlgoPFPM;
import java.io.IOException;

public class DescriptionAlgoPFPM
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PFPM";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#pfpm";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minPeriodicity = DescriptionAlgoPFPM.getParamAsInteger(parameters[0]);
        int maxPeriodicity = DescriptionAlgoPFPM.getParamAsInteger(parameters[1]);
        int minAveragePeriodicity = DescriptionAlgoPFPM.getParamAsInteger(parameters[2]);
        int maxAveragePeriodicity = DescriptionAlgoPFPM.getParamAsInteger(parameters[3]);
        AlgoPFPM algo = new AlgoPFPM();
        algo.runAlgorithm(inputFile, outputFile, minPeriodicity, maxPeriodicity, minAveragePeriodicity, maxAveragePeriodicity);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum periodicity", "(e.g. 1 transactions)", Integer.class, false), new DescriptionOfParameter("Maximum periodicity", "(e.g. 3 transactions)", Integer.class, false), new DescriptionOfParameter("Minimum average periodicity", "(e.g. 1 transactions)", Integer.class, false), new DescriptionOfParameter("Maximum average periodicity", "(e.g. 2 transactions)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Periodic patterns", "Periodic frequent patterns", "Periodic frequent itemsets"};
    }
}

