/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoPHM;
import java.io.IOException;

public class DescriptionAlgoPHM
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PHM";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#phm";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoPHM.getParamAsInteger(parameters[0]);
        int minPeriodicity = DescriptionAlgoPHM.getParamAsInteger(parameters[1]);
        int maxPeriodicity = DescriptionAlgoPHM.getParamAsInteger(parameters[2]);
        int minAveragePeriodicity = DescriptionAlgoPHM.getParamAsInteger(parameters[3]);
        int maxAveragePeriodicity = DescriptionAlgoPHM.getParamAsInteger(parameters[4]);
        AlgoPHM algo = new AlgoPHM();
        algo.runAlgorithm(inputFile, outputFile, minutil, minPeriodicity, maxPeriodicity, minAveragePeriodicity, maxAveragePeriodicity);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 20)", Integer.class, false), new DescriptionOfParameter("Minimum periodicity", "(e.g. 1 transactions)", Integer.class, false), new DescriptionOfParameter("Maximum periodicity", "(e.g. 3 transactions)", Integer.class, false), new DescriptionOfParameter("Minimum average periodicity", "(e.g. 1 transactions)", Integer.class, false), new DescriptionOfParameter("Maximum average periodicity", "(e.g. 2 transactions)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Periodic patterns", "High-utility patterns", "Periodic frequent patterns", "Periodic high-utility itemsets"};
    }
}

