/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.rulegen.AlgoRuleGen;
import java.io.IOException;

public class DescriptionAlgoRuleGen
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "RuleGen";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#rulegen";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minsup = DescriptionAlgoRuleGen.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoRuleGen.getParamAsDouble(parameters[1]);
        AlgoRuleGen rulegen = new AlgoRuleGen();
        rulegen.runAlgorithm(minsup, minconf, inputFile, outputFile);
        rulegen.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup", "(e.g. 3 sequences)", Integer.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential rules", "Ordered frequent sequential rules"};
    }
}

