/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.AlgoRULEGROWTH;
import java.io.IOException;

public class DescriptionAlgoRuleGrowth
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "RuleGrowth";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#rulegrowth";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoRuleGrowth.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoRuleGrowth.getParamAsDouble(parameters[1]);
        AlgoRULEGROWTH algo = new AlgoRULEGROWTH();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setMaxAntecedentSize(DescriptionAlgoRuleGrowth.getParamAsInteger(parameters[2]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxConsequentSize(DescriptionAlgoRuleGrowth.getParamAsInteger(parameters[3]));
        }
        algo.runAlgorithm(minsup, minconf, inputFile, outputFile);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Max consequent size", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential rules", "Frequent sequential rules"};
    }
}

