/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoBIDEPlus;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.AlgoDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.AlgoSeqDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoSeqDIMBideCharm
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "SeqDim_(BIDE+Charm)";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#exampleMDSPM1";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoSeqDIMBideCharm.getParamAsDouble(parameters[0]);
        MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
        contextMDDatabase.loadFile(inputFile);
        AlgoDim algoDim = new AlgoDim(false, true);
        AlgoSeqDim algoSeqDim = new AlgoSeqDim();
        AlgoBIDEPlus bideplus = new AlgoBIDEPlus(minsup);
        algoSeqDim.runAlgorithm(contextMDDatabase, bideplus, algoDim, true, outputFile);
        algoSeqDim.printStatistics(contextMDDatabase.size());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Multi-dimensional sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns", "Multi-dimensional frequent closed sequential patterns"};
    }
}

