/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.gui.PreferencesManager;
import java.io.IOException;
import java.nio.charset.Charset;

public class DescriptionAlgoSetPreferredCharset
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Set_prefered_charset";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SPMF Options";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#textcharset";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String encoding = DescriptionAlgoSetPreferredCharset.getParamAsString(parameters[0]);
        if (encoding.equals("default")) {
            encoding = Charset.defaultCharset().name();
        }
        PreferencesManager.getInstance().setPreferedCharset(encoding);
        System.out.println("Charset preference saved");
        System.out.println(PreferencesManager.getInstance().getPreferedCharset().name());
        System.out.println("This preference indicates which charset to use to read text files.");
        System.out.println("Currently, this preference is not used by most algorithm implementations.");
        System.out.println("In the future, most implementations will be modified to use the user selected charset.");
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Prefered charset", "(e.g. default, UTF-8, UTF-16)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return null;
    }

    @Override
    public String[] getOutputFileTypes() {
        return null;
    }
}

