/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.trulegrowth.AlgoTRuleGrowth;
import java.io.IOException;

public class DescriptionAlgoTRuleGrowth
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TRuleGrowth";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#trulegrowth";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoTRuleGrowth.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoTRuleGrowth.getParamAsDouble(parameters[1]);
        int window = DescriptionAlgoTRuleGrowth.getParamAsInteger(parameters[2]);
        AlgoTRuleGrowth algo = new AlgoTRuleGrowth();
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxAntecedentSize(DescriptionAlgoTRuleGrowth.getParamAsInteger(parameters[3]));
        }
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            algo.setMaxConsequentSize(DescriptionAlgoTRuleGrowth.getParamAsInteger(parameters[4]));
        }
        algo.runAlgorithm(minsup, minconf, inputFile, outputFile, window);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.7 or 70%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.8 or 80%)", Double.class, false), new DescriptionOfParameter("Window size", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Max consequent size", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential rules", "Frequent sequential rules"};
    }
}

