/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.text_clusterer.TextClusterAlgo;
import java.io.IOException;

public class DescriptionAlgoTextClusterer
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TextClusterer";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#TextClusterer";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        boolean performStemming = DescriptionAlgoTextClusterer.getParamAsBoolean(parameters[0]);
        boolean removeStopWords = DescriptionAlgoTextClusterer.getParamAsBoolean(parameters[0]);
        TextClusterAlgo algo = new TextClusterAlgo();
        algo.runAlgorithm(inputFile, outputFile, performStemming, removeStopWords);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Perform stemming", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Remove stop words", "(e.g. true)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Sabarish Raghu";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Clusters", "Text clusters"};
    }
}

