/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.AlgoZart;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import java.io.IOException;

public class DescriptionAlgoZart
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Zart";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#zart";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoZart.getParamAsDouble(parameters[0]);
        TransactionDatabase context = new TransactionDatabase();
        context.loadFile(inputFile);
        AlgoZart zart = new AlgoZart();
        zart.runAlgorithm(context, minsup);
        zart.printStatistics();
        zart.saveResultsToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Closed and generator patterns", "Frequent closed and generator itemsets"};
    }
}

