/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR;

import java.util.BitSet;

public class RuleG
implements Comparable<RuleG> {
    private Integer[] itemset1;
    private Integer[] itemset2;
    public BitSet tids1;
    public BitSet common;
    public int maxLeft;
    public int maxRight;
    public boolean expandLR = false;
    private int count;

    public RuleG(Integer[] itemset1, Integer[] itemset2, int count, BitSet tids1, BitSet common, int maxLeft, int maxRight) {
        this.count = count;
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
        this.common = common;
        this.tids1 = tids1;
        this.maxLeft = maxLeft;
        this.maxRight = maxRight;
    }

    public Integer[] getItemset1() {
        return this.itemset1;
    }

    public Integer[] getItemset2() {
        return this.itemset2;
    }

    public int getAbsoluteSupport() {
        return this.count;
    }

    public double getConfidence() {
        return (double)this.count / (double)this.tids1.cardinality();
    }

    @Override
    public int compareTo(RuleG o) {
        int itemset2sizeB;
        int itemset1sizeB;
        if (o == this) {
            return 0;
        }
        int compare = this.getAbsoluteSupport() - o.getAbsoluteSupport();
        if (compare != 0) {
            return compare;
        }
        int itemset1sizeA = this.itemset1 == null ? 0 : this.itemset1.length;
        int compare2 = itemset1sizeA - (itemset1sizeB = o.itemset1 == null ? 0 : o.itemset1.length);
        if (compare2 != 0) {
            return compare2;
        }
        int itemset2sizeA = this.itemset2 == null ? 0 : this.itemset2.length;
        int compare3 = itemset2sizeA - (itemset2sizeB = o.itemset2 == null ? 0 : o.itemset2.length);
        if (compare3 != 0) {
            return compare3;
        }
        int compare4 = (int)(this.getConfidence() - o.getConfidence());
        if (compare != 0) {
            return compare4;
        }
        return this.hashCode() - o.hashCode();
    }

    public boolean equals(Object o) {
        RuleG ruleX = (RuleG)o;
        if (ruleX.itemset1.length != this.itemset1.length) {
            return false;
        }
        if (ruleX.itemset2.length != this.itemset2.length) {
            return false;
        }
        int i = 0;
        while (i < this.itemset1.length) {
            if (this.itemset1[i] != ruleX.itemset1[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.itemset2.length) {
            if (this.itemset2[i] != ruleX.itemset2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.toString(this.itemset1)) + " ==> " + this.toString(this.itemset2);
    }

    private String toString(Integer[] itemset) {
        StringBuilder temp = new StringBuilder();
        Integer[] integerArray = itemset;
        int n = itemset.length;
        int n2 = 0;
        while (n2 < n) {
            int item = integerArray[n2];
            temp.append(String.valueOf(item) + " ");
            ++n2;
        }
        return temp.toString();
    }
}

