/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.distanceFunctions;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.patterns.cluster.DoubleArray;

public class DistanceCosine
extends DistanceFunction {
    static String NAME = "cosine";

    @Override
    public double calculateDistance(DoubleArray vector1, DoubleArray vector2) {
        double dotproduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        int i = 0;
        while (i < vector1.data.length) {
            dotproduct += vector1.data[i] * vector2.data[i];
            norm1 += Math.pow(vector1.data[i], 2.0);
            norm2 += Math.pow(vector2.data[i], 2.0);
            ++i;
        }
        if (norm1 == 0.0 || norm2 == 0.0) {
            return 0.0;
        }
        return 1.0 - dotproduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    public static void main(String[] args) {
        DoubleArray array1 = new DoubleArray(new double[]{3.0, 2.0, 0.0, 5.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0});
        DoubleArray array2 = new DoubleArray(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 2.0});
        System.out.println(new DistanceCosine().calculateDistance(array1, array2));
        DoubleArray array4 = new DoubleArray(new double[]{0.0, 0.0});
        DoubleArray array3 = new DoubleArray(new double[]{0.0, 0.0});
        System.out.println(new DistanceCosine().calculateDistance(array3, array4));
    }

    @Override
    public String getName() {
        return NAME;
    }
}

